
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_potassium")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_B2")


    # Set objective function
    m.setObjective(6*x0 + 2*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(26*x0 + 7*x1 >= 19, "c0")
    m.addConstr(25*x0 + 21*x1 >= 22, "c1")
    m.addConstr(-6*x0 + 6*x1 >= 0, "c2")
    m.addConstr(26*x0 + 7*x1 <= 48, "c3")
    m.addConstr(25*x0 + 21*x1 <= 45, "c4")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams_of_potassium: %g' % x0.x)
        print('milligrams_of_vitamin_B2: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

