
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(lb=0, name="milligrams_of_potassium")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B2")

# Set the objective function
m.setObjective(6*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(26*x1 + 7*x2 >= 19, name="min_combined_immune_support")
m.addConstr(25*x1 + 21*x2 >= 22, name="min_combined_kidney_support")
m.addConstr(-6*x1 + 6*x2 >= 0, name="potassium_vitamin_B2_constraint")
m.addConstr(26*x1 + 7*x2 <= 48, name="max_combined_immune_support")
m.addConstr(25*x1 + 21*x2 <= 45, name="max_combined_kidney_support")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Potassium: {x1.x}")
    print(f"Milligrams of Vitamin B2: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
