
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_potassium", lb=0)  # lower bound is 0
    x2 = model.addVar(name="milligrams_of_vitamin_B2", lb=0)  # lower bound is 0

    # Objective function: minimize 6 * x1 + 2 * x2
    model.setObjective(6 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(26 * x1 + 7 * x2 >= 19, name="immune_support_index_min")
    model.addConstr(25 * x1 + 21 * x2 >= 22, name="kidney_support_index_min")
    model.addConstr(-6 * x1 + 6 * x2 >= 0, name="balance_constraint")
    model.addConstr(26 * x1 + 7 * x2 <= 48, name="immune_support_index_max")
    model.addConstr(25 * x1 + 21 * x2 <= 45, name="kidney_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x1.varValue}")
        print(f"Milligrams of vitamin B2: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
