
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Mary
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Dale
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # hours worked by Peggy
    x3 = model.addVar(vtype=gp.GRB.INTEGER, name="x3") # hours worked by Paul


    # Set objective function
    model.setObjective(3*x0 + 4*x1 + 3*x2 + 8*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x0 + 6*x1 + 4*x2 + 17*x3 <= 239, "c0")
    model.addConstr(2*x0 + 4*x2 + 17*x3 >= 59, "c1")
    model.addConstr(2*x0 + 6*x1 + 4*x2 >= 59, "c2")
    model.addConstr(2*x0 + 6*x1 + 17*x3 >= 59, "c3")
    model.addConstr(2*x0 + 4*x2 + 17*x3 >= 34, "c4")
    model.addConstr(2*x0 + 6*x1 + 4*x2 >= 34, "c5")
    model.addConstr(2*x0 + 6*x1 + 17*x3 >= 34, "c6")
    model.addConstr(2*x0 + 4*x2 + 17*x3 >= 29, "c7")
    model.addConstr(2*x0 + 6*x1 + 4*x2 >= 29, "c8")
    model.addConstr(2*x0 + 6*x1 + 17*x3 >= 29, "c9")
    model.addConstr(6*x1 + 4*x2 <= 73, "c10")
    model.addConstr(2*x0 + 4*x2 + 17*x3 <= 124, "c11")
    model.addConstr(6*x1 + 4*x2 + 17*x3 <= 118, "c12")
    model.addConstr(2*x0 + 6*x1 + 4*x2 <= 69, "c13")
    model.addConstr(2*x0 + 6*x1 + 4*x2 + 17*x3 <= 69, "c14")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
