
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', vtype='I')  # hours worked by Mary
x2 = m.addVar(name='x2')  # hours worked by Dale
x3 = m.addVar(name='x3', vtype='I')  # hours worked by Peggy
x4 = m.addVar(name='x4', vtype='I')  # hours worked by Paul

# Define the objective function
m.setObjective(3*x1 + 4*x2 + 3*x3 + 8*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 <= 239)
m.addConstr(6*x2 <= 239)
m.addConstr(4*x3 <= 239)
m.addConstr(17*x4 <= 239)

m.addConstr(2*x1 + 4*x3 + 17*x4 >= 59)
m.addConstr(2*x1 + 6*x2 + 4*x3 >= 59)
m.addConstr(2*x1 + 6*x2 + 17*x4 >= 59)
m.addConstr(2*x1 + 4*x3 + 17*x4 >= 34)
m.addConstr(2*x1 + 6*x2 + 4*x3 >= 34)
m.addConstr(2*x1 + 6*x2 + 17*x4 >= 34)
m.addConstr(2*x1 + 4*x3 + 17*x4 >= 29)
m.addConstr(2*x1 + 6*x2 + 4*x3 >= 29)
m.addConstr(2*x1 + 6*x2 + 17*x4 >= 29)

m.addConstr(6*x2 + 4*x3 <= 73)
m.addConstr(2*x1 + 4*x3 + 17*x4 <= 124)
m.addConstr(6*x2 + 4*x3 + 17*x4 <= 118)
m.addConstr(2*x1 + 6*x2 + 4*x3 <= 69)
m.addConstr(2*x1 + 6*x2 + 4*x3 + 17*x4 <= 69)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Mary: ', x1.varValue)
    print('Hours worked by Dale: ', x2.varValue)
    print('Hours worked by Peggy: ', x3.varValue)
    print('Hours worked by Paul: ', x4.varValue)
else:
    print('No optimal solution found')
