
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")
lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
decorative_cabbages = m.addVar(vtype=gp.GRB.INTEGER, name="decorative_cabbages")
ferns = m.addVar(vtype=gp.GRB.INTEGER, name="ferns")


# Set objective function
m.setObjective(9.63 * chili_plants + 1.35 * lilies + 9.63 * decorative_cabbages + 7.06 * ferns, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(26 * lilies + 12 * decorative_cabbages >= 94)
m.addConstr(18 * chili_plants + 12 * decorative_cabbages >= 48)
m.addConstr(12 * decorative_cabbages + 18 * ferns >= 74)
m.addConstr(26 * lilies + 18 * ferns >= 71)
m.addConstr(18 * chili_plants + 26 * lilies >= 51)
m.addConstr(18 * chili_plants + 12 * decorative_cabbages + 18 * ferns >= 74)
m.addConstr(20 * chili_plants + 23 * ferns >= 65)
m.addConstr(20 * chili_plants + 8 * decorative_cabbages >= 43)
m.addConstr(8 * decorative_cabbages + 23 * ferns >= 58)
m.addConstr(23 * lilies + 8 * decorative_cabbages >= 87)
m.addConstr(20 * chili_plants + 23 * lilies >= 77)
m.addConstr(26 * lilies + 12 * decorative_cabbages <= 317)
m.addConstr(18 * chili_plants + 18 * ferns <= 380)
m.addConstr(18 * chili_plants + 12 * decorative_cabbages <= 243)
m.addConstr(18 * chili_plants + 26 * lilies + 12 * decorative_cabbages + 18 * ferns <= 243)
m.addConstr(23 * lilies + 8 * decorative_cabbages <= 227)
m.addConstr(23 * lilies + 23 * ferns <= 107)
m.addConstr(20 * chili_plants + 8 * decorative_cabbages + 23 * ferns <= 304)
m.addConstr(20 * chili_plants + 23 * lilies + 8 * decorative_cabbages + 23 * ferns <= 304)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

