
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="lilies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="decorative_cabbages", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="ferns", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.63 * x0 + 1.35 * x1 + 9.63 * x2 + 7.06 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(26 * x1 + 12 * x2 >= 94)
    model.addConstr(18 * x0 + 12 * x2 >= 48)
    model.addConstr(12 * x2 + 18 * x3 >= 74)
    model.addConstr(26 * x1 + 18 * x3 >= 71)
    model.addConstr(18 * x0 + 26 * x1 >= 51)
    model.addConstr(18 * x0 + 12 * x2 + 18 * x3 >= 74)
    model.addConstr(20 * x0 + 23 * x3 >= 65)
    model.addConstr(20 * x0 + 8 * x2 >= 43)
    model.addConstr(8 * x2 + 23 * x3 >= 58)
    model.addConstr(23 * x1 + 8 * x2 >= 87)
    model.addConstr(20 * x0 + 23 * x1 >= 77)
    model.addConstr(26 * x1 + 12 * x2 <= 317)
    model.addConstr(18 * x0 + 18 * x3 <= 380)
    model.addConstr(18 * x0 + 12 * x2 <= 243)
    model.addConstr(18 * x0 + 26 * x1 + 12 * x2 + 18 * x3 <= 243)
    model.addConstr(23 * x1 + 8 * x2 <= 227)
    model.addConstr(23 * x1 + 23 * x3 <= 107)
    model.addConstr(20 * x0 + 8 * x2 + 23 * x3 <= 304)
    model.addConstr(20 * x0 + 23 * x1 + 8 * x2 + 23 * x3 <= 304)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chili plants: ", x0.varValue)
        print("Lilies: ", x1.varValue)
        print("Decorative cabbages: ", x2.varValue)
        print("Ferns: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
