
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")


# Set objective function
m.setObjective(7 * bananas + 4 * eggs + 9 * chickens, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * bananas + 6 * chickens >= 18, "c1")
m.addConstr(3 * eggs + 6 * chickens >= 18, "c2")
m.addConstr(18 * bananas + 3 * eggs + 6 * chickens >= 18, "c3")
m.addConstr(4 * bananas - 6 * chickens >= 0, "c4")
m.addConstr(8 * eggs - 9 * chickens >= 0, "c5")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bananas:', bananas.x)
    print('eggs:', eggs.x)
    print('rotisserie_chickens:', chickens.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

