
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name='bananas', lb=0)  # Number of bananas
x2 = m.addVar(name='eggs', lb=0)     # Number of eggs
x3 = m.addVar(name='rotisserie_chickens', lb=0)  # Number of rotisserie chickens

# Define the objective function
m.setObjective(7*x1 + 4*x2 + 9*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(18*x1 + 6*x3 >= 18, name='calcium_from_bananas_and_chickens')
m.addConstr(3*x2 + 6*x3 >= 18, name='calcium_from_eggs_and_chickens')
m.addConstr(18*x1 + 3*x2 + 6*x3 >= 18, name='total_calcium')
m.addConstr(4*x1 - 6*x3 >= 0, name='bananas_and_chickens_constraint')
m.addConstr(8*x2 - 9*x3 >= 0, name='eggs_and_chickens_constraint')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bananas: {x1.x}")
    print(f"Eggs: {x2.x}")
    print(f"Rotisserie Chickens: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
