
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
bananas = model.addVar(name="bananas", lb=0)  # Non-negative
eggs = model.addVar(name="eggs", lb=0)  # Non-negative
rotisserie_chickens = model.addVar(name="rotisserie_chickens", lb=0)  # Non-negative

# Objective function
model.setObjective(7 * bananas + 4 * eggs + 9 * rotisserie_chickens, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(18 * bananas + 3 * eggs + 6 * rotisserie_chickens <= 164)
model.addConstr(18 * bananas + 6 * rotisserie_chickens >= 18)
model.addConstr(3 * eggs + 6 * rotisserie_chickens >= 18)
model.addConstr(18 * bananas + 3 * eggs + 6 * rotisserie_chickens >= 18)
model.addConstr(4 * bananas - 6 * rotisserie_chickens >= 0)
model.addConstr(8 * eggs - 9 * rotisserie_chickens >= 0)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {bananas.varValue}")
    print(f"Eggs: {eggs.varValue}")
    print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
