
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="cartons_of_milk")
    x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")
    x2 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")


    # Set objective function
    m.setObjective(3*x0 + 3*x1 + 5*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15*x0 + 8*x1 + 23*x2 <= 304, "dollar_cost")
    m.addConstr(4*x0 + 1*x1 + 17*x2 <= 340, "usefulness_rating")
    m.addConstr(8*x1 + 23*x2 >= 35, "napkins_plates_cost")
    m.addConstr(15*x0 + 8*x1 >= 96, "milk_napkins_cost")
    m.addConstr(15*x0 + 8*x1 + 23*x2 >= 96, "total_cost_min")
    m.addConstr(4*x0 + 17*x2 >= 84, "milk_plates_usefulness")
    m.addConstr(4*x0 + 1*x1 >= 58, "milk_napkins_usefulness")
    m.addConstr(4*x0 + 1*x1 + 17*x2 >= 89, "total_usefulness")
    m.addConstr(-4*x0 + 7*x2 >= 0, "milk_plates_relation")
    m.addConstr(15*x0 + 8*x1 + 23*x2 <= 221, "total_cost_max")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('cartons_of_milk:', x0.x)
        print('packs_of_napkins:', x1.x)
        print('packs_of_paper_plates:', x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
