
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(3*x0 + 3*x1 + 5*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(15*x0 + 8*x1 + 23*x2 <= 304)
    model.addConstr(4*x0 + x1 + 17*x2 >= 340)
    model.addConstr(8*x1 + 23*x2 >= 35)
    model.addConstr(15*x0 + 8*x1 >= 96)
    model.addConstr(15*x0 + 8*x1 + 23*x2 >= 96)
    model.addConstr(4*x0 + 17*x2 >= 84)
    model.addConstr(4*x0 + x1 >= 58)
    model.addConstr(4*x0 + x1 + 17*x2 >= 89)
    model.addConstr(-4*x0 + 7*x2 >= 0)
    model.addConstr(15*x0 + 8*x1 + 23*x2 <= 221)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cartons of milk: {x0.varValue}")
        print(f"Packs of napkins: {x1.varValue}")
        print(f"Packs of paper plates: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
