
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="pathfinder_teams")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="artillery_batteries")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="logistics_companies")


    # Set objective function
    m.setObjective(5*x0 + 3*x1 + 5*x2 + 8*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*x1 + 15*x3 >= 45)
    m.addConstr(16*x0 + 10*x2 >= 43)
    m.addConstr(8*x1 + 10*x2 >= 49)
    m.addConstr(8*x1 + 10*x2 + 15*x3 >= 58)
    m.addConstr(16*x0 + 10*x2 + 15*x3 >= 58)
    m.addConstr(8*x1 + 10*x2 + 15*x3 >= 41)
    m.addConstr(16*x0 + 10*x2 + 15*x3 >= 41)
    m.addConstr(9*x1 + 6*x2 >= 62)
    m.addConstr(9*x1 + 13*x3 >= 66)
    m.addConstr(1*x0 + 13*x3 >= 36)
    m.addConstr(6*x2 + 13*x3 >= 74)
    m.addConstr(16*x0 + 15*x3 <= 123)
    m.addConstr(8*x1 + 15*x3 <= 161)
    m.addConstr(16*x0 + 8*x1 <= 215)
    m.addConstr(16*x0 + 8*x1 + 10*x2 + 15*x3 <= 215)
    m.addConstr(1*x0 + 6*x2 <= 220)
    m.addConstr(1*x0 + 13*x3 <= 113)
    m.addConstr(9*x1 + 13*x3 <= 141)
    m.addConstr(6*x2 + 13*x3 <= 329)
    m.addConstr(1*x0 + 9*x1 + 6*x2 + 13*x3 <= 329)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
