
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # pathfinder teams
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # artillery batteries
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # CBRN platoons
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # logistics companies

    # Objective function
    model.setObjective(5*x0 + 3*x1 + 5*x2 + 8*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8*x1 + 15*x3 >= 45)
    model.addConstr(16*x0 + 10*x2 >= 43)
    model.addConstr(8*x1 + 10*x2 >= 49)
    model.addConstr(8*x1 + 10*x2 + 15*x3 >= 58)
    model.addConstr(16*x0 + 10*x2 + 15*x3 >= 58)
    model.addConstr(8*x1 + 10*x2 + 15*x3 >= 41)
    model.addConstr(16*x0 + 10*x2 >= 41)
    model.addConstr(9*x1 + 6*x2 >= 62)
    model.addConstr(9*x1 + 13*x3 >= 66)
    model.addConstr(x0 + 13*x3 >= 36)
    model.addConstr(6*x2 + 13*x3 >= 74)
    model.addConstr(16*x0 + 15*x3 <= 123)
    model.addConstr(8*x1 + 15*x3 <= 161)
    model.addConstr(16*x0 + 8*x1 <= 215)
    model.addConstr(16*x0 + 8*x1 + 10*x2 + 15*x3 <= 215)
    model.addConstr(x0 + 6*x2 <= 220)
    model.addConstr(x0 + 13*x3 <= 113)
    model.addConstr(9*x1 + 13*x3 <= 141)
    model.addConstr(6*x2 + 13*x3 <= 329)
    model.addConstr(x0 + 9*x1 + 6*x2 + 13*x3 <= 329)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Pathfinder teams: ", x0.varValue)
        print("Artillery batteries: ", x1.varValue)
        print("CBRN platoons: ", x2.varValue)
        print("Logistics companies: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
