
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    kale_salads = m.addVar(vtype=gp.GRB.INTEGER, name="kale_salads")
    tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
    bacon_strips = m.addVar(vtype=gp.GRB.INTEGER, name="bacon_strips")

    # Set objective function
    m.setObjective(9 * kale_salads + 1 * tomatoes + 6 * bacon_strips, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3 * kale_salads + 14 * tomatoes >= 20)
    m.addConstr(14 * tomatoes + 2 * bacon_strips >= 13)
    m.addConstr(3 * kale_salads + 14 * tomatoes + 2 * bacon_strips >= 21)
    m.addConstr(8 * kale_salads + 13 * tomatoes >= 51)
    m.addConstr(13 * tomatoes + 8 * bacon_strips >= 45)
    m.addConstr(8 * kale_salads + 8 * bacon_strips >= 21)
    m.addConstr(8 * kale_salads + 13 * tomatoes + 8 * bacon_strips >= 21)
    m.addConstr(7 * kale_salads + 5 * tomatoes >= 57)
    m.addConstr(7 * kale_salads + 5 * tomatoes + 3 * bacon_strips >= 57)
    m.addConstr(-5 * tomatoes + 4 * bacon_strips >= 0)
    m.addConstr(-6 * kale_salads + 9 * tomatoes >= 0)
    m.addConstr(3 * kale_salads + 14 * tomatoes <= 48)

    # Resource Constraints
    m.addConstr(3 * kale_salads <= 71)
    m.addConstr(8 * kale_salads <= 153)
    m.addConstr(7 * kale_salads <= 235)
    m.addConstr(14 * tomatoes <= 71)
    m.addConstr(13 * tomatoes <= 153)
    m.addConstr(5 * tomatoes <= 235)
    m.addConstr(2 * bacon_strips <= 71)
    m.addConstr(8 * bacon_strips <= 153)
    m.addConstr(3 * bacon_strips <= 235)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
