
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")


    # Set objective function
    model.setObjective(8.02 * laura_hours + 3.31 * ringo_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * laura_hours >= 12, "c0")
    model.addConstr(13 * laura_hours >= 13, "c1")
    model.addConstr(16 * laura_hours >= 16, "c2")
    model.addConstr(1 * ringo_hours >= 1, "c3")
    model.addConstr(17 * ringo_hours >= 17, "c4")
    model.addConstr(16 * ringo_hours >= 16, "c5")
    model.addConstr(12 * laura_hours + 1 * ringo_hours >= 68, "c6")
    model.addConstr(13 * laura_hours + 17 * ringo_hours >= 44, "c7")
    model.addConstr(16 * laura_hours + 16 * ringo_hours >= 38, "c8")
    model.addConstr(-5 * laura_hours + 2 * ringo_hours >= 0, "c9")
    model.addConstr(12 * laura_hours + 1 * ringo_hours <= 151, "c10")
    model.addConstr(13 * laura_hours + 17 * ringo_hours <= 102, "c11")
    model.addConstr(16 * laura_hours + 16 * ringo_hours <= 187, "c12")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
