
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(lb=0, ub=10.38, name="hours_worked_by_Laura") # Assuming non-negative
x2 = m.addVar(lb=0, ub=7.94, name="hours_worked_by_Ringo") # Assuming non-negative

# Define the objective function
m.setObjective(8.02*x1 + 3.31*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + x2 >= 68)
m.addConstr(13*x1 + 17*x2 >= 44)
m.addConstr(16*x1 + 16*x2 >= 38)
m.addConstr(-5*x1 + 2*x2 >= 0)
m.addConstr(12*x1 + x2 <= 151)
m.addConstr(13*x1 + 17*x2 <= 102)
m.addConstr(16*x1 + 16*x2 <= 187)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
else:
    print("The model is infeasible")
