
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="logistics_companies")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="mechanized_infantry_companies")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="pathfinder_teams")


    # Set objective function
    m.setObjective(4*x0**2 + 2*x0*x1 + 2*x1**2 + 2*x0 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.31*x0 + 5.74*x1 >= 85)
    m.addConstr(1.31*x0 + 7.85*x2 >= 102)
    m.addConstr(1.31*x0 + 5.74*x1 + 7.85*x2 >= 102)
    m.addConstr(5.2*x1 + 0.69*x2 >= 28)
    m.addConstr(0.44*x0 + 0.69*x2 >= 29)
    m.addConstr(0.44*x0 + 5.2*x1 + 0.69*x2 >= 29)
    m.addConstr(1.17*x1 + 1.66*x2 >= 156)
    m.addConstr(4.18*x0 + 1.17*x1 + 1.66*x2 >= 156)
    m.addConstr(3*x1**2 - 6*x2**2 >= 0)
    m.addConstr(5.2*x1 + 0.69*x2 <= 201)
    m.addConstr(4.18*x0 + 1.66*x2 <= 249)
    m.addConstr(1.17*x1**2 + 1.66*x2**2 <= 320)
    m.addConstr(4.18*x0**2 + 1.17*x1**2 + 1.66*x2**2 <= 233)

    # Resource Constraints
    m.addConstr(1.31*x0 <= 337)
    m.addConstr(0.44*x0 <= 217)
    m.addConstr(4.18*x0 <= 562)
    m.addConstr(5.74*x1 <= 337)
    m.addConstr(5.2*x1 <= 217)
    m.addConstr(1.17*x1 <= 562)
    m.addConstr(7.85*x2 <= 337)
    m.addConstr(0.69*x2 <= 217)
    m.addConstr(1.66*x2 <= 562)



    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('logistics_companies:', x0.x)
        print('mechanized_infantry_companies:', x1.x)
        print('pathfinder_teams:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
