
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="pathfinder_teams", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(4*x0**2 + 2*x0*x1 + 2*x1**2 + 2*x0 + 5*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(1.31*x0 == 1.31, name="defensive_capability_logistics")
m.addConstr(0.44*x0 == 0.44, name="fun_factor_logistics")
m.addConstr(4.18*x0 == 4.18, name="fuel_demand_logistics")
# m.addConstr(5.74*x1 == 5.74, name="defensive_capability_mechanized_infantry") 
# m.addConstr(5.2*x1 == 5.2, name="fun_factor_mechanized_infantry")
# m.addConstr(1.17*x1 == 1.17, name="fuel_demand_mechanized_infantry")
# m.addConstr(7.85*x2 == 7.85, name="defensive_capability_pathfinder")
# m.addConstr(0.69*x2 == 0.69, name="fun_factor_pathfinder")
# m.addConstr(1.66*x2 == 1.66, name="fuel_demand_pathfinder")

m.addConstr(1.31*x0 + 5.74*x1 >= 85, name="defensive_capability_logistics_mechanized_infantry")
m.addConstr(1.31*x0 + 7.85*x2 >= 102, name="defensive_capability_logistics_pathfinder")
m.addConstr(1.31*x0 + 5.74*x1 + 7.85*x2 >= 102, name="defensive_capability_all")

m.addConstr(5.2*x1 + 0.69*x2 >= 28, name="fun_factor_mechanized_infantry_pathfinder")
m.addConstr(0.44*x0 + 0.69*x2 >= 29, name="fun_factor_logistics_pathfinder")
m.addConstr(0.44*x0 + 5.2*x1 + 0.69*x2 >= 29, name="fun_factor_all")

m.addConstr(1.17*x1 + 1.66*x2 >= 156, name="fuel_demand_mechanized_infantry_pathfinder")
m.addConstr(4.18*x0 + 1.17*x1 + 1.66*x2 >= 156, name="fuel_demand_all")

m.addConstr(3*x1**2 - 6*x2**2 >= 0, name="relationship_mechanized_infantry_pathfinder")
m.addConstr(5.2*x1 + 0.69*x2 <= 201, name="fun_factor_limit_mechanized_infantry_pathfinder")
m.addConstr(4.18*x0 + 1.66*x2 <= 249, name="fuel_demand_limit_logistics_pathfinder")
m.addConstr((1.17*x1)**2 + (1.66*x2)**2 <= 320, name="fuel_demand_squared_limit_mechanized_infantry_pathfinder")
m.addConstr((4.18*x0)**2 + (1.17*x1)**2 + (1.66*x2)**2 <= 233, name="fuel_demand_squared_limit_all")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Logistics companies: ", x0.varValue)
    print("Mechanized infantry companies: ", x1.varValue)
    print("Pathfinder teams: ", x2.varValue)
else:
    print("The model is infeasible")
