
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls of instant ramen")
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hot dogs")


    # Set objective function
    m.setObjective(6.45 * x0 * x1 + 2.48 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * x0 + 6 * x1 >= 61, "tastiness_constraint1")
    m.addConstr(-6 * x0 + 7 * x1 >= 0, "constraint2")
    m.addConstr(5 * x0 + 6 * x1 <= 175, "tastiness_ub")
    m.addConstr(25 * x0 * x0 + 36 * x1 * x1 <= 122, "squared_tastiness")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"bowls of instant ramen: {x0.x}")
        print(f"hot dogs: {x1.x}")
        print(f"Objective value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

