
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="bowls_of_instant_ramen", vtype=GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="hot_dogs", vtype=GRB.INTEGER)

# Set the objective function
m.setObjective(6.45*x1*x2 + 2.48*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 6*x2 >= 61, name="total_tastiness")
m.addConstr(-6*x1 + 7*x2 >= 0, name="bowls_hot_dogs_constraint")
m.addConstr((5*x1)**2 + (6*x2)**2 <= 122, name="squared_tastiness")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bowls of instant ramen: {x1.x}")
    print(f"Number of hot dogs: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
