
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="bowls_of_instant_ramen", lb=0)  
x2 = m.addVar(name="hot_dogs", lb=0, vtype=gp.GRB.INTEGER)  

# Define the objective function
m.setObjective(6.45 * x1 * x2 + 2.48 * x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(5 * x1 + 6 * x2 >= 61)
m.addConstr(-6 * x1 + 7 * x2 >= 0)
m.addConstr(25 * x1**2 + 36 * x2**2 <= 122)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bowls of instant ramen: {x1.varValue}")
    print(f"Hot dogs: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
