
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milkshakes")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")

    # Set objective function
    m.setObjective(9*x0 + 7*x1 + 7*x2 + 6*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5.6*x0 + 1.47*x1 + 7.28*x2 + 4.38*x3 <= 113, "fiber_limit")
    m.addConstr(4.32*x0 + 3.11*x1 + 6.23*x2 + 1.15*x3 <= 85, "sourness_limit")
    m.addConstr(1.47*x1 + 7.28*x2 >= 28, "fiber_ham_milkshakes_min")
    m.addConstr(5.6*x0 + 1.47*x1 >= 9, "fiber_pasta_ham_min")
    m.addConstr(1.47*x1 + 4.38*x3 >= 28, "fiber_ham_bacon_min")
    m.addConstr(5.6*x0 + 7.28*x2 >= 17, "fiber_pasta_milkshakes_min")
    m.addConstr(6.23*x2 + 1.15*x3 >= 9, "sourness_milkshakes_bacon_min")
    m.addConstr(4.32*x0 + 6.23*x2 >= 19, "sourness_pasta_milkshakes_min")
    m.addConstr(4.32*x0 + 1.15*x3 >= 8, "sourness_pasta_bacon_min")
    m.addConstr(3.11*x1 + 6.23*x2 >= 20, "sourness_ham_milkshakes_min")
    m.addConstr(4.32*x0 + 3.11*x1 + 6.23*x2 >= 15, "sourness_pasta_ham_milkshakes_min")
    m.addConstr(1.47*x1 + 7.28*x2 <= 66, "fiber_ham_milkshakes_max")
    m.addConstr(5.6*x0 + 1.47*x1 <= 51, "fiber_pasta_ham_max")
    m.addConstr(5.6*x0 + 4.38*x3 <= 85, "fiber_pasta_bacon_max")
    m.addConstr(5.6*x0 + 1.47*x1 + 7.28*x2 + 4.38*x3 <= 85, "fiber_total_max")
    m.addConstr(4.32*x0 + 3.11*x1 <= 71, "sourness_pasta_ham_max")
    m.addConstr(6.23*x2 + 1.15*x3 <= 37, "sourness_milkshakes_bacon_max")
    m.addConstr(3.11*x1 + 1.15*x3 <= 30, "sourness_ham_bacon_max")
    m.addConstr(4.32*x0 + 6.23*x2 <= 65, "sourness_pasta_milkshakes_max")
    m.addConstr(4.32*x0 + 3.11*x1 + 6.23*x2 + 1.15*x3 <= 65, "sourness_total_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
