
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
x0 = model.addVar(vtype=GRB.INTEGER, name="rubber gloves")
x1 = model.addVar(vtype=GRB.INTEGER, name="packs of napkins")
x2 = model.addVar(vtype=GRB.INTEGER, name="paper towel rolls")
x3 = model.addVar(vtype=GRB.INTEGER, name="cartons of milk")
x4 = model.addVar(vtype=GRB.INTEGER, name="bottles of ibuprofen")


# Set objective function
model.setObjective(5.13 * x0 + 2.16 * x1 + 4.35 * x2 + 7.67 * x3 + 8.66 * x4, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * x0 + 2 * x2 >= 11, "c0")
model.addConstr(5 * x0 + 4 * x3 >= 13, "c1")
model.addConstr(7 * x0 + 3 * x3 >= 15, "c2")
model.addConstr(2 * x2 + 3 * x3 >= 8, "c3")
model.addConstr(7 * x0 + 2 * x2 + 2 * x4 >= 12, "c4")
model.addConstr(2 * x2 + 3 * x3 + 2 * x4 >= 12, "c5")
model.addConstr(7 * x0 + 2 * x2 + 3 * x3 >= 12, "c6")
model.addConstr(7 * x0 + 2 * x2 + 2 * x4 >= 14, "c7")
model.addConstr(2 * x2 + 3 * x3 + 2 * x4 >= 14, "c8")
model.addConstr(7 * x0 + 2 * x2 + 3 * x3 >= 14, "c9")
model.addConstr(7 * x0 + 2 * x2 + 2 * x4 >= 17, "c10")
model.addConstr(2 * x2 + 3 * x3 + 2 * x4 >= 17, "c11")
model.addConstr(7 * x0 + 2 * x2 + 3 * x3 >= 17, "c12")
model.addConstr(2 * x1 + 1 * x3 >= 16, "c13")
model.addConstr(2 * x1 + 8 * x4 >= 16, "c14")
model.addConstr(8 * x0 + 2 * x1 >= 7, "c15")
model.addConstr(8 * x0 + 8 * x4 >= 12, "c16")
model.addConstr(7 * x2 + 1 * x3 >= 5, "c17")
model.addConstr(7 * x2 + 8 * x4 >= 6, "c18")
model.addConstr(8 * x0 + 7 * x2 >= 12, "c19")
model.addConstr(3 * x2 + 1 * x4 >= 14, "c20")
model.addConstr(1 * x0 + 7 * x1 + 5 * x3 >= 18, "c21")
# ... (rest of the constraints)



# Resource constraints (using the provided dictionary)
resources = {
    'r0': {'description': 'sustainability score', 'upper_bound': 99, 'x0': 5, 'x1': 7, 'x2': 2, 'x3': 4, 'x4': 2},
    'r1': {'description': 'storage space', 'upper_bound': 87, 'x0': 7, 'x1': 4, 'x2': 2, 'x3': 3, 'x4': 2},
    'r2': {'description': 'portability rating', 'upper_bound': 83, 'x0': 8, 'x1': 2, 'x2': 7, 'x3': 1, 'x4': 8},
    'r3': {'description': 'dollar value', 'upper_bound': 92, 'x0': 1, 'x1': 7, 'x2': 3, 'x3': 5, 'x4': 1}
}

for resource, data in resources.items():
    model.addConstr(
        data['x0'] * x0 + data['x1'] * x1 + data['x2'] * x2 + data['x3'] * x3 + data['x4'] * x4 <= data['upper_bound'],
        f"{resource}_ub"
    )


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

