
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="rubber_gloves", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="bottles_of_ibuprofen", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.13*x0 + 2.16*x1 + 4.35*x2 + 7.67*x3 + 8.66*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x0 + 2*x2 >= 11)
    model.addConstr(5*x0 + 4*x3 >= 13)
    model.addConstr(7*x1 + 4*x3 <= 72)
    model.addConstr(7*x1 + 2*x4 <= 52)
    model.addConstr(5*x0 + 7*x1 <= 61)
    model.addConstr(7*x1 + 2*x2 <= 63)
    model.addConstr(5*x0 + 2*x2 <= 59)
    model.addConstr(4*x3 + 2*x4 <= 89)
    model.addConstr(5*x0 + 2*x2 + 4*x3 <= 51)
    model.addConstr(5*x0 + 7*x1 + 4*x3 <= 33)
    model.addConstr(5*x0 + 2*x2 + 2*x4 <= 70)
    model.addConstr(5*x0 + 7*x1 + 2*x2 + 4*x3 + 2*x4 <= 70)
    model.addConstr(7*x0 + 4*x1 <= 39)
    model.addConstr(7*x0 + 2*x2 + 2*x4 <= 34)
    model.addConstr(4*x1 + 2*x2 + 2*x4 <= 60)
    model.addConstr(3*x3 + 2*x4 <= 49)
    model.addConstr(7*x0 + 2*x2 <= 52)
    model.addConstr(7*x0 + 4*x1 + 2*x2 + 3*x3 + 2*x4 <= 75)
    model.addConstr(2*x1 + x3 >= 16)
    model.addConstr(2*x1 + 8*x4 >= 16)
    model.addConstr(8*x0 + 2*x1 >= 7)
    model.addConstr(8*x0 + 8*x4 >= 12)
    model.addConstr(7*x2 + x3 >= 5)
    model.addConstr(7*x2 + 8*x4 >= 6)
    model.addConstr(8*x0 + 7*x2 >= 12)
    model.addConstr(2*x1 + x3 <= 35)
    model.addConstr(8*x0 + x3 <= 54)
    model.addConstr(8*x0 + 2*x1 + 7*x2 + x3 + 8*x4 <= 54)
    model.addConstr(x0 + 3*x2 <= 18)
    model.addConstr(3*x2 + x4 <= 45)
    model.addConstr(7*x1 + x4 <= 69)
    model.addConstr(3*x2 + 5*x3 <= 58)
    model.addConstr(x0 + x4 <= 66)
    model.addConstr(5*x3 + x4 <= 49)
    model.addConstr(7*x1 + 3*x2 + 5*x3 <= 75)
    model.addConstr(x0 + 7*x1 + 3*x2 + 5*x3 + x4 <= 75)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("rubber gloves: ", x0.varValue)
        print("packs of napkins: ", x1.varValue)
        print("paper towel rolls: ", x2.varValue)
        print("cartons of milk: ", x3.varValue)
        print("bottles of ibuprofen: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
