
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b2 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="vitamin_b2")
vitamin_d = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="vitamin_d")
vitamin_c = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="vitamin_c")
vitamin_b5 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="vitamin_b5")
vitamin_b9 = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="vitamin_b9")
fat = m.addVar(lb=0, ub=gp.GRB.INFINITY, name="fat")


# Set objective function
m.setObjective(7.93 * vitamin_b2 + 9.93 * vitamin_d + 2.02 * vitamin_c + 5.41 * vitamin_b5 + 9.32 * vitamin_b9 + 1.66 * fat, gp.GRB.MINIMIZE)

# Add constraints - Resource constraints are added as upper bounds to variables. The rest are below.
m.addConstr(20.84 * vitamin_b5 + 22.58 * fat >= 94)
m.addConstr(15.79 * vitamin_c + 20.84 * vitamin_b5 >= 54)
m.addConstr(29.87 * vitamin_b2 + 18.52 * vitamin_d >= 133)
m.addConstr(15.79 * vitamin_c + 29.02 * vitamin_b9 >= 114)
m.addConstr(18.52 * vitamin_d + 15.79 * vitamin_c >= 111)
m.addConstr(15.79 * vitamin_c + 20.84 * vitamin_b5 + 29.02 * vitamin_b9 >= 127)
m.addConstr(29.87 * vitamin_b2 + 20.84 * vitamin_b5 + 29.02 * vitamin_b9 >= 127)
# ... (add all other constraints similarly)
m.addConstr(14.75 * vitamin_b2 + 32.77 * vitamin_b5 >= 103)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

