
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
oranges = m.addVar(name="oranges", lb=0)
bowls_of_pasta = m.addVar(name="bowls_of_pasta", lb=0)
cornichons = m.addVar(name="cornichons", lb=0)

# Define the objective function
m.setObjective(5.56 * oranges + 8.24 * bowls_of_pasta + 7.5 * cornichons, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(oranges + 4 * bowls_of_pasta + 2 * cornichons >= 32, name="protein_total")
m.addConstr(oranges + 2 * cornichons >= 26, name="protein_oranges_cornichons")
m.addConstr(2 * bowls_of_pasta + 7 * cornichons >= 8, name="carbohydrates_pasta_cornichons")
m.addConstr(5 * oranges + 2 * bowls_of_pasta >= 6, name="carbohydrates_oranges_pasta")
m.addConstr(5 * oranges + 2 * bowls_of_pasta + 7 * cornichons >= 6, name="carbohydrates_all")
m.addConstr(bowls_of_pasta + 8 * cornichons >= 40, name="fat_pasta_cornichons")
m.addConstr(7 * oranges + bowls_of_pasta >= 35, name="fat_oranges_pasta")
m.addConstr(7 * oranges + bowls_of_pasta + 8 * cornichons >= 35, name="fat_all")
m.addConstr(-oranges + 7 * bowls_of_pasta >= 0, name="oranges_pasta_relationship")
m.addConstr(5 * oranges + 2 * bowls_of_pasta + 7 * cornichons <= 42, name="carbohydrates_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oranges: ", oranges.varValue)
    print("Bowls of pasta: ", bowls_of_pasta.varValue)
    print("Cornichons: ", cornichons.varValue)
else:
    print("The model is infeasible")
