
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")


# Set objective function
m.setObjective(3*security_engineers**2 + 3*security_engineers*patches_per_day + 3*automatic_alerts**2 + 3*automatic_alerts*patches_per_day + 2*patches_per_day**2 + 6*automatic_alerts, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*security_engineers + 23*automatic_alerts + 1*patches_per_day <= 165, "c0")
m.addConstr(10*security_engineers + 23*automatic_alerts >= 21, "c1")
m.addConstr((10*security_engineers)**2 + (1*patches_per_day)**2 >= 35, "c2")
m.addConstr(10*security_engineers + 23*automatic_alerts + 1*patches_per_day >= 35, "c3")
m.addConstr(10*security_engineers - 1*patches_per_day >= 0, "c4")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('security_engineers:', security_engineers.x)
    print('automatic_alerts:', automatic_alerts.x)
    print('patches_per_day:', patches_per_day.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

