
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="automatic_alerts", lb=0)
x3 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")

# Define the objective function
m.setObjective(3*x1**2 + 3*x1*x3 + 3*x2**2 + 3*x2*x3 + 2*x3**2 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 23*x2 >= 21, name="confidentiality_impact_security_and_alerts")
m.addConstr((10*x1)**2 + x3**2 >= 35, name="security_and_patches_squared_impact")
m.addConstr(10*x1 + 23*x2 + x3 >= 35, name="total_confidentiality_impact")
m.addConstr(10*x1 - x3 >= 0, name="security_vs_patches")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Security Engineers: {x1.x}")
    print(f"Automatic Alerts: {x2.x}")
    print(f"Patches per Day: {x3.x}")
else:
    print("No optimal solution found.")
