
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="automatic_alerts", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="patches_per_day", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3*x1**2 + 3*x1*x3 + 3*x2**2 + 3*x2*x3 + 2*x3**2 + 6*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10*x1 + 23*x2 >= 21)
    model.addConstr(100*x1**2 + x3**2 >= 35)
    model.addConstr(10*x1 + 23*x2 + x3 >= 35)
    model.addConstr(10*x1 - x3 >= 0)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Security Engineers: {x1.varValue}")
        print(f"Automatic Alerts: {x2.varValue}")
        print(f"Patches per Day: {x3.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
