
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
napkins = model.addVar(vtype=gp.GRB.INTEGER, name="napkins")
gloves = model.addVar(vtype=gp.GRB.INTEGER, name="gloves")
lightbulbs = model.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
cookies = model.addVar(vtype=gp.GRB.INTEGER, name="cookies")
toilet_paper = model.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper")

# Set objective function
model.setObjective(6*napkins + 5*gloves + 2*lightbulbs + 8*cookies + 2*toilet_paper, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(13.56*napkins + 14.78*cookies >= 28)
model.addConstr(11.3*gloves + 0.93*lightbulbs >= 31)
model.addConstr(0.93*lightbulbs + 1.38*toilet_paper >= 11)
model.addConstr(13.56*napkins + 0.93*lightbulbs >= 16)
model.addConstr(13.56*napkins + 14.78*cookies + 1.38*toilet_paper >= 22)
model.addConstr(11.3*gloves + 0.93*lightbulbs + 1.38*toilet_paper >= 22)
model.addConstr(13.56*napkins + 11.3*gloves + 14.78*cookies >= 22)
model.addConstr(11.3*gloves + 0.93*lightbulbs + 14.78*cookies >= 22)
model.addConstr(13.56*napkins + 14.78*cookies + 1.38*toilet_paper >= 30)
model.addConstr(11.3*gloves + 0.93*lightbulbs + 1.38*toilet_paper >= 30)
model.addConstr(13.56*napkins + 11.3*gloves + 14.78*cookies >= 30)
model.addConstr(11.3*gloves + 0.93*lightbulbs + 14.78*cookies >= 30)


model.addConstr(2.75*gloves + 14.35*lightbulbs + 3.84*cookies >= 19)
model.addConstr(13.17*napkins + 2.75*gloves + 13.36*toilet_paper >= 19)
model.addConstr(2.75*gloves + 3.84*cookies + 13.36*toilet_paper >= 19)
model.addConstr(13.17*napkins + 3.84*cookies + 13.36*toilet_paper >= 19)
model.addConstr(2.75*gloves + 14.35*lightbulbs + 3.84*cookies >= 25)
model.addConstr(13.17*napkins + 2.75*gloves + 13.36*toilet_paper >= 25)
model.addConstr(2.75*gloves + 3.84*cookies + 13.36*toilet_paper >= 25)
model.addConstr(13.17*napkins + 3.84*cookies + 13.36*toilet_paper >= 25)
model.addConstr(2.75*gloves + 14.35*lightbulbs + 3.84*cookies >= 27)
model.addConstr(13.17*napkins + 2.75*gloves + 13.36*toilet_paper >= 27)
model.addConstr(2.75*gloves + 3.84*cookies + 13.36*toilet_paper >= 27)
model.addConstr(13.17*napkins + 3.84*cookies + 13.36*toilet_paper >= 27)


model.addConstr(0.93*lightbulbs + 14.78*cookies <= 85)
model.addConstr(13.56*napkins + 14.78*cookies <= 155)
model.addConstr(11.3*gloves + 0.93*lightbulbs + 1.38*toilet_paper <= 60)
model.addConstr(11.3*gloves + 0.93*lightbulbs + 14.78*cookies <= 146)
model.addConstr(13.56*napkins + 11.3*gloves + 0.93*lightbulbs + 14.78*cookies + 1.38*toilet_paper <= 146)
model.addConstr(14.35*lightbulbs + 3.84*cookies <= 31)
model.addConstr(13.17*napkins + 13.36*toilet_paper <= 53)
model.addConstr(2.75*gloves + 3.84*cookies <= 62)
model.addConstr(13.17*napkins + 14.35*lightbulbs <= 92)
model.addConstr(3.84*cookies + 13.36*toilet_paper <= 104)
model.addConstr(14.35*lightbulbs + 13.36*toilet_paper <= 72)
model.addConstr(13.17*napkins + 2.75*gloves <= 110)
model.addConstr(13.17*napkins + 3.84*cookies <= 115)
model.addConstr(13.17*napkins + 2.75*gloves + 14.35*lightbulbs + 3.84*cookies + 13.36*toilet_paper <= 115)

model.addConstr(13.56*napkins + 11.3*gloves + 0.93*lightbulbs + 14.78*cookies + 1.38*toilet_paper <= 158)
model.addConstr(13.17*napkins + 2.75*gloves + 14.35*lightbulbs + 3.84*cookies + 13.36*toilet_paper <= 137)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Napkins: {napkins.x}")
    print(f"Gloves: {gloves.x}")
    print(f"Lightbulbs: {lightbulbs.x}")
    print(f"Cookies: {cookies.x}")
    print(f"Toilet Paper: {toilet_paper.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

