
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Bobby")
    x1 = model.addVar(lb=0, name="hours_worked_by_Mary")


    # Set objective function
    model.setObjective(9.26*x0**2 + 9.08*x0*x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.12*x0 + 0.75*x1 >= 28, "organization_score_lower_bound")
    model.addConstr(0.34*x0 + 0.74*x1 >= 22, "work_quality_rating_lower_bound")
    model.addConstr(-10*x0 + 6*x1 >= 0, "constraint_3")
    model.addConstr(0.12*x0 + 0.75*x1 <= 73, "organization_score_upper_bound")
    model.addConstr(0.34*x0 + 0.74*x1 <= 109, "work_quality_rating_upper_bound")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Bobby: {x0.x}")
        print(f"Hours worked by Mary: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
