
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Bobby')
x2 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Mary')

# Set the objective function
m.setObjective(9.26*x1**2 + 9.08*x1*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.12*x1 + 0.75*x2 >= 28, name='organization_score_min')
m.addConstr(0.34*x1 + 0.74*x2 >= 22, name='work_quality_rating_min')
m.addConstr(-10*x1 + 6*x2 >= 0, name='inequality_constraint')
m.addConstr(0.12*x1 + 0.75*x2 <= 73, name='organization_score_max')
m.addConstr(0.34*x1 + 0.74*x2 <= 109, name='work_quality_rating_max')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Hours worked by Mary: {x2.x}")
else:
    print("No optimal solution found")
