
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Bobby")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Mary")

    # Define the objective function
    model.setObjective(9.26 * x1**2 + 9.08 * x1 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.12 * x1 + 0.75 * x2 >= 28, name="organization_score_constraint")
    model.addConstr(0.34 * x1 + 0.74 * x2 >= 22, name="work_quality_rating_constraint")
    model.addConstr(-10 * x1 + 6 * x2 >= 0, name="hourly_work_constraint")
    model.addConstr(0.12 * x1 + 0.75 * x2 <= 73, name="organization_score_upper_bound")
    model.addConstr(0.34 * x1 + 0.74 * x2 <= 109, name="work_quality_rating_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
        print("Objective function value: ", model.objVal)
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimize_problem()
