
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")


# Set objective function
m.setObjective(2 * vitamin_a + 7 * vitamin_b6 + 5 * zinc + 7 * vitamin_b1 + 3 * vitamin_d, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(6 * vitamin_b1 + 6 * vitamin_d >= 17)
m.addConstr(zinc + 6 * vitamin_d >= 24)
m.addConstr(zinc + 6 * vitamin_b1 >= 34)


kidney_support_constraints = [
    (4, 4, 1, 6, 6)
]

thresholds = [26, 27, 31, 33, 34, 45, 48]

variables = [vitamin_a, vitamin_b6, zinc, vitamin_b1, vitamin_d]

for ksc in kidney_support_constraints:
    for t in thresholds:
        m.addConstr(ksc[0] * vitamin_a + ksc[1] * vitamin_b6 + ksc[2] * zinc + ksc[3] * vitamin_b1 + ksc[4] * vitamin_d >= t)

m.addConstr(4 * vitamin_b6 + zinc <= 221)
m.addConstr(4 * vitamin_b6 + 6 * vitamin_d <= 55)
m.addConstr(zinc + 6 * vitamin_b1 <= 229)
m.addConstr(6 * vitamin_b1 + 6 * vitamin_d <= 98)
m.addConstr(4 * vitamin_a + 4 * vitamin_b6 + 6 * vitamin_b1 <= 161)
m.addConstr(4 * vitamin_a + zinc + 6 * vitamin_b1 <= 95)
m.addConstr(4 * vitamin_a + 4 * vitamin_b6 + zinc <= 244)
m.addConstr(4 * vitamin_a + 4 * vitamin_b6 + zinc + 6 * vitamin_b1 + 6 * vitamin_d <= 244)
m.addConstr(4 * vitamin_a + 4 * vitamin_b6 + zinc + 6 * vitamin_b1 + 6 * vitamin_d <= 253)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

