
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin A
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B6
    x3 = model.addVar(name="x3", lb=0)  # milligrams of zinc
    x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin B1
    x5 = model.addVar(name="x5", lb=0)  # milligrams of vitamin D

    # Objective function
    model.setObjective(2*x1 + 7*x2 + 5*x3 + 7*x4 + 3*x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x1 <= 253)
    model.addConstr(4*x2 <= 253)
    model.addConstr(x3 <= 253)
    model.addConstr(6*x4 <= 253)
    model.addConstr(6*x5 <= 253)
    model.addConstr(6*x4 + 6*x5 >= 17)
    model.addConstr(x3 + 6*x5 >= 24)
    model.addConstr(x3 + 6*x4 >= 34)
    model.addConstr(4*x2 + x3 + 6*x5 >= 31)
    model.addConstr(4*x1 + 4*x2 + 6*x4 >= 31)
    model.addConstr(4*x1 + x3 + 6*x4 >= 31)
    model.addConstr(4*x2 + 6*x4 + 6*x5 >= 31)
    model.addConstr(4*x1 + x3 + 6*x5 >= 31)
    model.addConstr(4*x1 + 4*x2 + 6*x5 >= 31)
    model.addConstr(x3 + 6*x4 + 6*x5 >= 31)
    model.addConstr(4*x2 + x3 + 6*x5 >= 33)
    model.addConstr(4*x1 + 4*x2 + 6*x4 >= 33)
    model.addConstr(4*x1 + x3 + 6*x4 >= 33)
    model.addConstr(4*x2 + 6*x4 + 6*x5 >= 33)
    model.addConstr(4*x1 + x3 + 6*x5 >= 33)
    model.addConstr(4*x1 + 4*x2 + 6*x5 >= 33)
    model.addConstr(x3 + 6*x4 + 6*x5 >= 33)
    model.addConstr(4*x2 + x3 + 6*x5 >= 48)
    model.addConstr(4*x1 + 4*x2 + 6*x4 >= 48)
    model.addConstr(4*x1 + x3 + 6*x4 >= 48)
    model.addConstr(4*x2 + 6*x4 + 6*x5 >= 48)
    model.addConstr(4*x1 + x3 + 6*x5 >= 48)
    model.addConstr(4*x1 + 4*x2 + 6*x5 >= 48)
    model.addConstr(x3 + 6*x4 + 6*x5 >= 48)
    model.addConstr(4*x2 + x3 <= 221)
    model.addConstr(4*x2 + 6*x5 <= 55)
    model.addConstr(x3 + 6*x4 <= 229)
    model.addConstr(6*x4 + 6*x5 <= 98)
    model.addConstr(4*x1 + 4*x2 + 6*x4 <= 161)
    model.addConstr(4*x1 + x3 + 6*x4 <= 95)
    model.addConstr(4*x1 + 4*x2 + x3 <= 244)
    model.addConstr(4*x1 + 4*x2 + x3 + 6*x4 + 6*x5 <= 244)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Milligrams of zinc: {x3.varValue}")
        print(f"Milligrams of vitamin B1: {x4.varValue}")
        print(f"Milligrams of vitamin D: {x5.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
