
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")
    x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")


    # Set objective function
    m.setObjective(1.42*x0 + 9.1*x1 + 8.22*x2 + 3.08*x3 + 2.28*x4, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*x2 + 6*x3 >= 40)
    m.addConstr(7*x1 + 6*x3 >= 16)
    m.addConstr(7*x0 + 9*x2 >= 33)
    m.addConstr(7*x0 + 7*x1 + 7*x4 >= 41)
    m.addConstr(7*x0 + 7*x1 + 9*x2 + 6*x3 + 7*x4 >= 41)
    m.addConstr(6*x2 - 6*x3 >= 0)
    m.addConstr(5*x2 - 4*x4 >= 0)
    m.addConstr(-3*x0 + 5*x1 >= 0)
    m.addConstr(7*x1 + 9*x2 <= 54)
    m.addConstr(7*x1 + 6*x3 <= 56)
    m.addConstr(7*x0 + 6*x3 <= 169)
    m.addConstr(7*x1 + 9*x2 + 6*x3 <= 125)
    m.addConstr(7*x0 + 9*x2 + 6*x3 <= 205)
    m.addConstr(7*x0 + 9*x2 + 7*x4 <= 122)
    m.addConstr(9*x2 + 6*x3 + 7*x4 <= 215)
    m.addConstr(7*x0 + 7*x1 + 6*x3 <= 111)
    m.addConstr(7*x0 + 7*x1 + 7*x4 <= 158)
    m.addConstr(7*x1 + 6*x3 + 7*x4 <= 58)
    m.addConstr(7*x1 + 9*x2 + 7*x4 <= 197)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
