
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="x1", lb=0)  # grams of carbohydrates
x2 = model.addVar(name="x2", lb=0)  # milligrams of potassium
x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B9
x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin B1
x5 = model.addVar(name="x5", lb=0)  # milligrams of vitamin E

# Objective function
model.setObjective(1.42 * x1 + 9.1 * x2 + 8.22 * x3 + 3.08 * x4 + 2.28 * x5, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(7 * x1 <= 221)
model.addConstr(7 * x2 <= 221)
model.addConstr(9 * x3 <= 221)
model.addConstr(6 * x4 <= 221)
model.addConstr(7 * x5 <= 221)

model.addConstr(9 * x3 + 6 * x4 >= 40)
model.addConstr(7 * x2 + 6 * x4 >= 16)
model.addConstr(7 * x1 + 9 * x3 >= 33)
model.addConstr(7 * x1 + 7 * x2 + 7 * x5 >= 41)
model.addConstr(7 * x1 + 7 * x2 + 9 * x3 + 6 * x4 + 7 * x5 >= 41)

model.addConstr(6 * x3 - 6 * x4 >= 0)
model.addConstr(5 * x3 - 4 * x5 >= 0)
model.addConstr(-3 * x1 + 5 * x2 >= 0)

model.addConstr(7 * x2 + 9 * x3 <= 54)
model.addConstr(7 * x2 + 6 * x4 <= 56)
model.addConstr(7 * x1 + 6 * x4 <= 169)
model.addConstr(7 * x2 + 9 * x3 + 6 * x4 <= 125)
model.addConstr(7 * x1 + 9 * x3 + 6 * x4 <= 205)
model.addConstr(7 * x1 + 9 * x3 + 7 * x5 <= 122)
model.addConstr(9 * x3 + 6 * x4 + 7 * x5 <= 215)
model.addConstr(7 * x1 + 7 * x2 + 6 * x4 <= 111)
model.addConstr(7 * x1 + 7 * x2 + 7 * x5 <= 158)
model.addConstr(7 * x2 + 6 * x4 + 7 * x5 <= 58)
model.addConstr(7 * x2 + 9 * x3 + 7 * x5 <= 197)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("The model is infeasible")
