
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Paul
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Jean
    x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2")  # hours worked by Laura


    # Set objective function
    m.setObjective(4*x0 + 3*x1 + 8*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4.21*x0 == 4.21, "c0")
    m.addConstr(2.1*x0 == 2.1, "c1")
    m.addConstr(7.97*x1 == 7.97, "c2")
    m.addConstr(16.79*x1 == 16.79, "c3")
    m.addConstr(10.3*x2 == 10.3, "c4")
    m.addConstr(5.13*x2 == 5.13, "c5")
    m.addConstr(7.97*x1 + 10.3*x2 >= 19, "c6")
    m.addConstr(4.21*x0 + 10.3*x2 >= 28, "c7")
    m.addConstr(4.21*x0 + 7.97*x1 + 10.3*x2 >= 31, "c8")
    m.addConstr(16.79*x1 + 5.13*x2 >= 61, "c9")
    m.addConstr(2.1*x0 + 5.13*x2 >= 61, "c10")
    m.addConstr(2.1*x0 + 16.79*x1 + 5.13*x2 >= 32, "c11")
    m.addConstr(-2*x0 + x2 >= 0, "c12")
    m.addConstr(4.21*x0 + 10.3*x2 <= 49, "c13")
    m.addConstr(2.1*x0 + 5.13*x2 <= 113, "c14")
    m.addConstr(2.1*x0 + 16.79*x1 <= 151, "c15")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0:', x0.x)
        print('x1:', x1.x)
        print('x2:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
