
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Paul", lb=-float('inf'), ub=float('inf'))
    x1 = model.addVar(name="hours_worked_by_Jean", lb=0, ub=float('inf'), integrality=1)
    x2 = model.addVar(name="hours_worked_by_Laura", lb=0, ub=float('inf'), integrality=1)

    # Objective function
    model.setObjective(4*x0 + 3*x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7.97*x1 + 10.3*x2 >= 19)
    model.addConstr(4.21*x0 + 10.3*x2 >= 28)
    model.addConstr(4.21*x0 + 7.97*x1 + 10.3*x2 >= 31)
    model.addConstr(16.79*x1 + 5.13*x2 >= 61)
    model.addConstr(2.1*x0 + 5.13*x2 >= 61)
    model.addConstr(-2*x0 + x2 >= 0)
    model.addConstr(4.21*x0 + 10.3*x2 <= 49)
    model.addConstr(2.1*x0 + 5.13*x2 <= 113)
    model.addConstr(2.1*x0 + 16.79*x1 <= 151)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x0.varValue}")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by Laura: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
