
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
hank_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
dale_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale_hours")

# Set objective function
model.setObjective(6.54 * hank_hours + 6.17 * dale_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(18 * hank_hours + 7 * dale_hours >= 57, "quit_index_min")
model.addConstr(8 * hank_hours + 16 * dale_hours >= 67, "quality_rating_min")
model.addConstr(4 * hank_hours - dale_hours >= 0, "hank_dale_ratio")
model.addConstr(18 * hank_hours + 7 * dale_hours <= 123, "quit_index_max")
model.addConstr(8 * hank_hours + 16 * dale_hours <= 70, "quality_rating_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Hank's hours: {hank_hours.x}")
    print(f"Dale's hours: {dale_hours.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

