
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale", lb=0)

# Set the objective function
m.setObjective(6.54*x1 + 6.17*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*x1 + 7*x2 >= 57, "likelihood_to_quit_index_min")
m.addConstr(8*x1 + 16*x2 >= 67, "work_quality_rating_min")
m.addConstr(4*x1 - x2 >= 0, "hours_worked_constraint")
m.addConstr(18*x1 + 7*x2 <= 123, "likelihood_to_quit_index_max")
m.addConstr(8*x1 + 16*x2 <= 70, "work_quality_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
