
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Hank", vtype=gp.GRB.INTEGER) # integer hours
x2 = m.addVar(name="hours_worked_by_Dale") # continuous hours

# Define the objective function
m.setObjective(6.54 * x1 + 6.17 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(18 * x1 + 7 * x2 >= 57, name="likelihood_to_quit_index_constraint")
m.addConstr(8 * x1 + 16 * x2 >= 67, name="work_quality_rating_constraint")
m.addConstr(4 * x1 - x2 >= 0, name="hours_worked_constraint")
m.addConstr(18 * x1 + 7 * x2 <= 123, name="likelihood_to_quit_index_upper_bound_constraint")
m.addConstr(8 * x1 + 16 * x2 <= 70, name="work_quality_rating_upper_bound_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x1.varValue}")
    print(f"Hours worked by Dale: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
