
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
    laura_hours = model.addVar(vtype=GRB.INTEGER, name="laura_hours")
    paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")


    # Set objective function
    model.setObjective(2*dale_hours + 4*laura_hours + 2*paul_hours, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13*dale_hours + 29*laura_hours >= 107, "dollar_cost_dale_laura_min")
    model.addConstr(13*dale_hours + 29*laura_hours + 20*paul_hours >= 84, "dollar_cost_total_min")
    model.addConstr(10*dale_hours + 3*laura_hours >= 76, "org_score_dale_laura_min")
    model.addConstr(10*dale_hours + 25*paul_hours >= 58, "org_score_dale_paul_min")
    model.addConstr(10*dale_hours + 3*laura_hours + 25*paul_hours >= 58, "org_score_total_min")
    model.addConstr(laura_hours - 5*paul_hours >= 0, "laura_paul_relation")
    model.addConstr(13*dale_hours + 29*laura_hours <= 392, "dollar_cost_dale_laura_max")
    model.addConstr(13*dale_hours + 20*paul_hours <= 343, "dollar_cost_dale_paul_max")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
