
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul

    # Objective function
    model.setObjective(2 * x0 + 4 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13 * x0 + 29 * x1 >= 107)
    model.addConstr(13 * x0 + 29 * x1 + 20 * x2 >= 84)
    model.addConstr(10 * x0 + 3 * x1 >= 76)
    model.addConstr(10 * x0 + 25 * x2 >= 58)
    model.addConstr(10 * x0 + 3 * x1 + 25 * x2 >= 58)
    model.addConstr(x1 - 5 * x2 >= 0)
    model.addConstr(13 * x0 + 29 * x1 <= 392)
    model.addConstr(13 * x0 + 20 * x2 <= 343)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {x0.varValue}")
        print(f"Hours worked by Laura: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
