
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
    b2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="b2")
    b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b3")


    # Set objective function
    m.setObjective(9*fat + 4*b2 + 2*b3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3.84*fat + 5.67*b3 >= 19, "c1")
    m.addConstr(3.84*fat + 4.56*b2 >= 16, "c2")
    m.addConstr(3.84*fat + 4.56*b2 + 5.67*b3 >= 16, "c3")
    m.addConstr(3*b2 - 2*b3 >= 0, "c4")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Fat: %g' % fat.x)
        print('B2: %g' % b2.x)
        print('B3: %g' % b3.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

