
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=-float('inf'), ub=float('inf'))  # grams of fat
    x2 = model.addVar(name="x2", lb=0, ub=float('inf'), vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B2
    x3 = model.addVar(name="x3", lb=-float('inf'), ub=float('inf'))  # milligrams of vitamin B3

    # Define the objective function
    model.setObjective(9 * x1 + 4 * x2 + 2 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3.84 * x1 <= 60)
    model.addConstr(4.56 * x2 <= 60)
    model.addConstr(5.67 * x3 <= 60)
    model.addConstr(3.84 * x1 + 5.67 * x3 >= 19)
    model.addConstr(3.84 * x1 + 4.56 * x2 >= 16)
    model.addConstr(3.84 * x1 + 4.56 * x2 + 5.67 * x3 >= 16)
    model.addConstr(3 * x2 - 2 * x3 >= 0)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fat: {x1.varValue}")
        print(f"Milligrams of vitamin B2: {x2.varValue}")
        print(f"Milligrams of vitamin B3: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
