
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
verbenas = m.addVar(vtype=gp.GRB.INTEGER, name="verbenas")
agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
peonies = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
geraniums = m.addVar(vtype=gp.GRB.INTEGER, name="geraniums")

# Set objective function
m.setObjective(3.32 * verbenas + 8.56 * agave + 3.32 * peonies + 8.22 * geraniums, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(26 * verbenas + 11 * agave + 20 * peonies + 9 * geraniums <= 193, "planting_space_limit")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies + 11 * geraniums <= 257, "resilience_index_limit")
m.addConstr(20 * peonies + 9 * geraniums >= 33 * 144, "peonies_geraniums_space")
m.addConstr(26 * verbenas + 9 * geraniums >= 28 * 144, "verbenas_geraniums_space")
m.addConstr(20 * verbenas + 11 * geraniums >= 28, "verbenas_geraniums_resilience")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies >= 42, "verbenas_agave_peonies_resilience")
m.addConstr(20 * verbenas + 11 * peonies + 11 * geraniums >= 42, "verbenas_peonies_geraniums_resilience")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies >= 55, "verbenas_agave_peonies_resilience2")
m.addConstr(20 * verbenas + 11 * peonies + 11 * geraniums >= 55, "verbenas_peonies_geraniums_resilience2")
m.addConstr(11 * agave + 9 * geraniums <= 168 * 144, "agave_geraniums_space_limit")
m.addConstr(26 * verbenas + 11 * agave + 20 * peonies + 9 * geraniums <= 168 * 144, "total_space_limit")
m.addConstr(5 * agave + 11 * peonies <= 175, "agave_peonies_resilience_limit")
m.addConstr(20 * verbenas + 11 * peonies <= 95, "verbenas_peonies_resilience_limit")
m.addConstr(20 * verbenas + 11 * geraniums <= 117, "verbenas_geraniums_resilience_limit")
m.addConstr(5 * agave + 11 * geraniums <= 210, "agave_geraniums_resilience_limit")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies + 11 * geraniums <= 210, "total_resilience_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

