
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='verbenas', vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name='agave', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='peonies', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='geraniums', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3.32*x0 + 8.56*x1 + 3.32*x2 + 8.22*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(26*x0 + 11*x1 + 20*x2 + 9*x3 <= 193)
model.addConstr(20*x0 + 5*x1 + 11*x2 + 11*x3 <= 257)
model.addConstr(20*x2 + 9*x3 >= 4752)
model.addConstr(26*x0 + 9*x3 >= 4032)
model.addConstr(20*x0 + 11*x3 >= 28)
model.addConstr(20*x0 + 5*x1 + 11*x2 >= 42)
model.addConstr(20*x0 + 11*x2 + 11*x3 >= 42)
model.addConstr(20*x0 + 5*x1 + 11*x2 >= 55)
model.addConstr(20*x0 + 11*x2 + 11*x3 >= 55)
model.addConstr(11*x1 + 9*x3 <= 24192)
model.addConstr(26*x0 + 11*x1 + 20*x2 + 9*x3 <= 24192)
model.addConstr(5*x1 + 11*x2 <= 175)
model.addConstr(20*x0 + 11*x2 <= 95)
model.addConstr(20*x0 + 11*x3 <= 117)
model.addConstr(5*x1 + 11*x3 <= 210)
model.addConstr(20*x0 + 5*x1 + 11*x2 + 11*x3 <= 210)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Verbenas: ', x0.varValue)
    print('Agave: ', x1.varValue)
    print('Peonies: ', x2.varValue)
    print('Geraniums: ', x3.varValue)
else:
    print('The model is infeasible')
