
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("minimize_food_cost")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="steaks")


    # Set objective function
    m.setObjective(4*x0 + 9*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(22*x0 + 14*x1 >= 77, "healthiness_lower")
    m.addConstr(22*x0 + 14*x1 <= 174, "healthiness_upper")
    m.addConstr(8*x0 + 4*x1 >= 75, "calcium_lower")
    m.addConstr(8*x0 + 4*x1 <= 218, "calcium_upper")
    m.addConstr(26*x0 + 20*x1 >= 43, "fat_lower")
    m.addConstr(26*x0 + 20*x1 <= 64, "fat_upper")
    m.addConstr(1*x0 - 5*x1 >= 0, "additional_constraint")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"Rotisserie Chickens: {x0.x}")
        print(f"Steaks: {x1.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
